<?php
    /*
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $inizioPeriodo = isset($_GET["inizioPeriodo"]) ? filter_input(INPUT_GET,"inizioPeriodo",FILTER_SANITIZE_ADD_SLASHES) : date("Y-01-01");
    $finePeriodo   = isset($_GET["finePeriodo"]) ? filter_input(INPUT_GET,"finePeriodo",FILTER_SANITIZE_ADD_SLASHES) : date("Y-m-d");
    
    // calcolo del bilancio
    $queryEntrate              = "SELECT SUM(totale) AS totale FROM geecAd_documentiContabili WHERE entrataUscita LIKE 'Entrata' AND dataEmissione >='$inizioPeriodo' AND dataEmissione <='$finePeriodo' AND tipo NOT LIKE 'preventivo' AND tipo NOT LIKE 'prima nota'";
    $risTotaleEntrate          = $geecomDb->eseguiQueryLettura($queryEntrate);
    $totaleEntrateAnnoCorrente = $risTotaleEntrate->fetch_assoc();
    if($totaleEntrateAnnoCorrente["totale"]=="") {
        $totaleEntrateAnnoCorrente["totale"] = 0;
    }

    $queryUscite              = "SELECT SUM(totale) AS totale FROM geecAd_documentiContabili WHERE entrataUscita LIKE 'Uscita' AND dataEmissione >='$inizioPeriodo' AND dataEmissione <='$finePeriodo' AND tipo NOT LIKE 'prima nota'";
    $risTotaleUscite          = $geecomDb->eseguiQueryLettura($queryUscite);
    $totaleUsciteAnnoCorrente = $risTotaleUscite->fetch_assoc();
    if($totaleUsciteAnnoCorrente["totale"]=="") {
        $totaleUsciteAnnoCorrente["totale"] = 0;
    }
    
    $bilancio = $totaleEntrateAnnoCorrente["totale"] - $totaleUsciteAnnoCorrente["totale"];
    if($bilancio>0) {
        $classe = "success";
        $classeFaccina = "smile";
    }
    else if($bilancio==0) {
        $classe = "warning";
        $classeFaccina = "meh";
    }
    else {
        $classe = "danger";
        $classeFaccina = "meh";
    }
    
    // calcolo dei soldi in cassa (prima nota)
    $queryEntratePrimaNota     = "SELECT SUM(totale) AS totale FROM geecAd_documentiContabili WHERE entrataUscita LIKE 'Entrata' AND dataEmissione >='$inizioPeriodo' AND dataEmissione <='$finePeriodo' AND tipo LIKE 'prima nota'";
    $risTotaleEntratePrimaNota = $geecomDb->eseguiQueryLettura($queryEntratePrimaNota);
    $totaleCassaAnnoCorrente   = $risTotaleEntratePrimaNota->fetch_assoc();
    if($totaleCassaAnnoCorrente["totale"]=="") {
        $totaleCassaAnnoCorrente["totale"] = 0;
    }

    $queryUscitePrimaNota     = "SELECT SUM(totale) AS totale FROM geecAd_documentiContabili WHERE entrataUscita LIKE 'Uscita' AND dataEmissione >='$inizioPeriodo' AND dataEmissione <='$finePeriodo' AND tipo LIKE 'prima nota'";
    $risTotaleUscitePrimaNota = $geecomDb->eseguiQueryLettura($queryUscitePrimaNota);
    $usciteCassaAnnoCorrente = $risTotaleUscitePrimaNota->fetch_assoc();
    if($usciteCassaAnnoCorrente["totale"]=="") {
        $usciteCassaAnnoCorrente["totale"] = 0;
    }
    
    $cassa = $totaleCassaAnnoCorrente["totale"] - $usciteCassaAnnoCorrente["totale"];
    
    if($cassa>0) {
        $classeCassa = "success";
        $classeFaccinaCassa = "smile";
    }
    else if($cassa==0) {
        $classeCassa = "warning";
        $classeFaccinaCassa = "meh";
    }
    else {
        $classeCassa = "danger";
        $classeFaccinaCassa = "meh";
    }
?>

<div class="card">
    <div class="card-header bg-light text-dark d-lg-flex align-items-center justify-content-end">
        <form class="form-inline">
            <label  class="mr-2">Dal</label>
            <input type="date" class="form-control form-control-sm mr-sm-2" name="inizioPeriodo" value="<?= $inizioPeriodo ?>">

            <label class="mr-2">Al</label>
            <input type="date" class="form-control form-control-sm mr-sm-2" name="finePeriodo" value="<?= $finePeriodo ?>">

            <button type="submit" class="btn btn-primary btn-sm mt-3 mt-sm-0 d-block"><i class="fas fa-search"></i></button>
        </form>
    </div>
    <div class="card-body">
        <div class="form-row">
            <div class="col-lg-3 mb-3 mb-lg-0">
                <div class="card text-center">
                    <div class="form-row">
                        <div class="col-sm-6 p-3 text-<?= $classe ?>">
                            <h6 class="my-2"><i class="far fa-<?= $classeFaccina ?> mr-2"></i>Bilancio </h6><h3 class="mt-1 mb-0">€ <?= $bilancio ?></h3>
                        </div>
                        <div class="col-sm-6 p-3 text-<?= $classeCassa ?>">
                            <h6 class="my-2"><i class="far fa-<?= $classeFaccinaCassa ?> mr-2"></i>Cassa </h6><h3 class="mt-1 mb-0">€ <?= $cassa ?></h3>
                        </div>
                    </div>
                </div>
            </div>
        <div class="col-lg-9">
            <div class="form-row">
                <div class="col-lg-6 text-center mb-3 mb-lg-0 text-primary">
                    <div class="card">
                        <div class="form-row">
                            <div class="col-sm-6 p-3">
                                <span>Entrate</span>
                                <h3 class="mt-1">€ <span class=""><?= $totaleEntrateAnnoCorrente["totale"] ?></span></h3>
                            </div>
                            <div class="col-sm-6 d-flex align-items-strech">
                                <div class="bg-light p-3 w-100 d-flex align-items-center">
                                    <div class="w-100">
                                        <button class="btn btn-primary btn-block btn-sm" type="button" data-toggle="collapse" data-target="#dettagliEntrate" aria-expanded="false" aria-controls="dettagliEntrate">
                                            Dettagli
                                        </button>
                                        <div class="collapse" id="dettagliEntrate">
                                            <dl class="row text-dark text-sm-left mt-3 mb-0">
                                                <?php 
                                                    $queryMetodiPagamento = "SELECT * FROM geecAd_etichette WHERE tipo LIKE 'metodoPagamento'";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryMetodiPagamento);
                                                    while($etichetta = $risNomi->fetch_assoc()) {
                                                        $etichettaEscape = filter_var($etichetta["nome"],FILTER_SANITIZE_ADD_SLASHES);
                                                        $query              = "SELECT SUM(totale) AS totale FROM geecAd_documentiContabili WHERE entrataUscita LIKE 'Entrata' AND dataEmissione >='$inizioPeriodo' AND dataEmissione <='$finePeriodo' AND tipo NOT LIKE 'preventivo' AND metodoPagamento LIKE '$etichettaEscape' AND tipo NOT LIKE 'prima nota'";
                                                        $risTotaleEntrateTipoPagamento = $geecomDb->eseguiQueryLettura($query);
                                                        $totaleEntrateTipoPagamentoAnnoCorrente = $risTotaleEntrateTipoPagamento->fetch_assoc();
                                                        if($totaleEntrateTipoPagamentoAnnoCorrente["totale"]=="") {
                                                            $totaleEntrateTipoPagamentoAnnoCorrente["totale"] = 0;
                                                        }
                                                ?>
                                                        <dt class="col-sm-7"><b><?= $etichetta["nome"] ?></b></dt>
                                                        <dd class="col-sm-5">€ <?= $totaleEntrateTipoPagamentoAnnoCorrente["totale"] ?></dd>
                                                <?php
                                                    }
                                                ?>
                                            </dl>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 text-center mb-3 mb-lg-0 text-secondary">
                    <div class="card">
                        <div class="form-row">
                            <div class="col-sm-6 p-3">
                                <span>Uscite</span>
                                <h3 class="mt-1">€ <span class=""><?= $totaleUsciteAnnoCorrente["totale"] ?></span></h3>
                            </div>
                            <div class="col-sm-6 d-flex align-items-strech">
                                <div class="bg-light p-3 w-100 d-flex align-items-center">
                                    <div class="w-100">
                                        <button class="btn btn-primary btn-block btn-sm" type="button" data-toggle="collapse" data-target="#dettagliUscite" aria-expanded="false" aria-controls="dettagliUscite">
                                            Dettagli
                                        </button>
                                        <div class="collapse" id="dettagliUscite">
                                            <dl class="row text-dark text-sm-left mt-3 mb-0">
                                                <?php 
                                                    $queryMetodiPagamento = "SELECT * FROM geecAd_etichette WHERE tipo LIKE 'contabilita'";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryMetodiPagamento);
                                                    while($etichetta = $risNomi->fetch_assoc()) {
                                                        $etichettaEscape = filter_var($etichetta["nome"],FILTER_SANITIZE_ADD_SLASHES);
                                                        $query = "SELECT SUM(totale) AS totale FROM geecAd_documentiContabili WHERE entrataUscita LIKE 'Uscita' AND dataEmissione >='$inizioPeriodo' AND dataEmissione <='$finePeriodo' AND tipo NOT LIKE 'preventivo' AND etichetta LIKE '$etichettaEscape' AND tipo NOT LIKE 'prima nota'";
                                                        $risTotaleEntrateTipoPagamento = $geecomDb->eseguiQueryLettura($query);
                                                        $totaleEntrateTipoPagamentoAnnoCorrente = $risTotaleEntrateTipoPagamento->fetch_assoc();
                                                        if($totaleEntrateTipoPagamentoAnnoCorrente["totale"]=="") {
                                                            $totaleEntrateTipoPagamentoAnnoCorrente["totale"] = 0;
                                                        }
                                                ?>
                                                        <dt class="col-sm-7"><b><?= $etichetta["nome"] ?></b></dt>
                                                        <dd class="col-sm-5">€ <?= $totaleEntrateTipoPagamentoAnnoCorrente["totale"] ?></dd>
                                                <?php
                                                    }
                                                ?>
                                            </dl>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
